﻿* Encoding: UTF-8.
*************************************************************************
*
* Beispielcodes für den Syntax-Editor zu Kapitel 16 (Ersteller: Fritz Kast)  
* Kast, F. (2016): "Inferenzstatistische Prüfung kategorialer Daten mitKontingenztabellen". In Herbert Schwetz et al. (Hg.): 
* "Einführung in das quantitativ orientierte Forschen".
*
*************************************************************************
*
* Daten von der Webseite des BIFIE http://dx.doi.org/10.17888/fdb-demo:bistM413I-16a beziehen. 
* Daten nach der Speicherung mit SPSS öffnen.
*
*******************************************************************************************
*
* Beispielcode für Tabelle 16-1; Seite 184:  Ergebnisse  für Chi-Quadrat-Tests
*
*******************************************************************************************
* Diese Befehlsfolge reproduziert das Ergebnis der Tabelle 16-1 auf Seite 184
* und entspricht dem Pfad auf Seite 184 bzw. den Screenshots in den Abbildungen 8-1  bis 8-4 und Abbildung 16-1.
*
* Markieren Sie mit der Maus die Zeilen CROSSTABS bis  /COUNT ROUND CELL und aktivieren Sie danach die Befehlsfolge 
* durch einen Klick auf das Symbol Syntax-Start (Ausführen oder grünes Dreieck im Syntax-Editor)  zur Berechnung.

CROSSTABS
  /TABLES=Kompetenzstufe BY Bildung
  /FORMAT=AVALUE TABLES
 /CELLS=COUNT 
  /STATISTICS=CHISQ 
  /COUNT ROUND CELL.
*
* Die Ergebnistabellen im Ausgabefenster - Kreuztabelle mit absoluten Zahlen (Tabelle 8-1 auf Seite 90) werden 
* aus Platzgründen im Buch nicht wiedergegeben.
*
*
**********************************************************
*
* 16:2 Die Vier-Felder-Tabelle als Spezialfall der Kontingenztabelle mit Assoziationsmaßen
*
************************************************************
* Dichotomisierung der Variablen
*
* Für die Vier-Felder-Tabellen in Tabelle 16-3 auf Seite 188  müssen einige Variablen dichotomisiert werden
*
**************************************************************
*
* Dichotomisierung der Variable "Bildung" zur Variable "Bildung_d" - Bildung dichotomisiert.
*
* Die Variable "Bildung" mit der Beschriftung "Höchste Ausbildung der Eltern" besitzt vier Ausprägungen,
* mit den numerischen Werten 1 bis 4.
* Der Zahl "1" ist die Beschriftung "APS", der Zahl "2" die Beschriftung "BA", der Zahl "3" die Beschriftung
* "Matura" und der Zahl "4" die Beschriftung "Uni&Ä" zugeordnet.
* Zur Dichotomisierung werden die Auspägungen "APS" und "BA" zu einer Kategorie mit dem Wert "0" 
* zusammengefasst und die Beschreibung "niedrig" zugeordnet; die Ausprägungen "Matura" und  
* "Uni&Ä" werden zur zweiten Kategorie mit dem Wert "1" zusammengefasst und der Wert "hoch"
* zugeordnet.
* Markieren Sie jeweil mit der Maus die Zeilen und aktivieren Sie danach die Befehlsfolge durch einen Klick 
* auf das Symbol Syntax-Start (Ausführen oder grünes Dreieck im Syntax-Editor)  zur Berechnung.

RECODE Bildung (1 thru 2=0) (3 thru 4=1) INTO Bildung_d.
VARIABLE LABELS  Bildung_d 'Bildung dichotomisiert'.
VALUE LABELS Bildung_d 0  'APS oder BS' 1  'höhere Bildung'.
EXECUTE.
*
******************************************************************
* Dichotomisierung der Variable "Kompetenzstufe" zur Variable "Kompetenz_d" - Kompetenzstufe dichotomisiert.
*
* Die Variable "Kompetenzstufe" mit der Beschriftung "Kompetenzstufe in Mathematik 4. Schulstufe" besitzt vier Ausprägungen,
* mit den numerischen Werten 0, 1, 2 und 3.
* Der Zahl "0" ist die Beschriftung "nicht erreicht", der Zahl "1" die Beschriftung "teilweise 
* erreicht", der Zahl "2" die Beschriftung "erreicht" und der Zahl "3" die Beschriftung "übertroffen" zugeordnet.
* Zur Dichotomisierung werden die Auspägungen "nicht erreicht" und "teilweise erreicht" zu einer Kategorie 
* mit dem Wert "0" * zusammengefasst und die Beschreibung "nicht oder tw. erreicht" zugeordnet; 
* die Ausprägungen "erreicht" und   "übertroffen" werden zur zweiten Kategorie mit dem Wert "1" zusammengefasst und 
* die Beschreibung  "erreicht oder übertroffen" zugeordnet.

RECODE Kompetenzstufe (0 thru 1=0) (2 thru 3=1) INTO Kompetenz_d.
VARIABLE LABELS  Kompetenz_d 'Kompetenzstufe dichotomisiert'.
VALUE LABELS Kompetenz_d 0 'nicht oder tw. erreicht' 1 'erreicht oder übertroffen'.
EXECUTE.
*
*********************************************************************
* Dichotomisierung der Variable "Freude" zur Variable "Freude_d" - Freude an Mathematik dichotomisiert.
*
* Die Variable "Freude" mit der Beschriftung "Freude an Mathematik" besitzt vier Ausprägungen,
* mit den numerischen Werten 1 bis 4.
* Der Zahl "1" ist die Beschriftung "niedrig", der Zahl "2" die Beschriftung "eher niedrig",
* der Zahl "3" die Beschriftung "eher hoch" und der Zahl "4" die Beschriftung "hoch" zugeordnet.
* Zur Dichotomisierung werden die Auspägungen "niedrig" und "eher niedrig" zu einer Kategorie 
* mit dem Wert "0"  zusammengefasst und die Beschreibung "niedrig" zugeordnet; 
* die Ausprägungen "eher hoch" und  "hoch" werden zur zweiten Kategorie mit dem Wert "1" 
* zusammengefasst und die Beschreibung "hoch* zugeordnet.

RECODE Freude (1 thru 2=0) (3 thru 4=1) INTO Freude_d.
VARIABLE LABELS  Freude_d 'Freude Mathematik dichotomisiert'.
VALUE LABELS  Freude_d 0 "niedrig" 1 "hoch".
EXECUTE.
*
***************************************************************
* Dichotomisierung der Variable "Selbstkonzept" zur Variable "Selbstkonzept_d" - Selbstkonzept in Mathematik dichotomisiert.
*
* Die Variable "Selbstkonzept" mit der Beschriftung "Selbstkonzept in Mathematik"  besitzt vier Ausprägungen,
* mit den numerischen Werten 1 bis 4.
* Der Zahl "1" ist die Beschriftung "niedrig", der Zahl "2" die Beschriftung "eher niedrig",
* der Zahl "3" die Beschriftung "eher hoch" und der Zahl "4" die Beschriftung "hoch" zugeordnet.
* Zur Dichotomisierung werden die Auspägungen "niedrig" und "eher niedrig" zu einer Kategorie 
* mit dem Wert "0"  zusammengefasst und die Beschreibung "niedrig" zugeordnet; 
* die Ausprägungen "eher hoch" und  "hoch" werden zur zweiten Kategorie mit dem Wert "1" 
* zusammengefasst und die Beschreibung "hoch" zugeordnet.

RECODE Selbstkonzept (1 thru 2=0) (3 thru 4=1) INTO Selbstkonzept_d.
VARIABLE LABELS  Selbstkonzept_d 'Selbstkonzept Mathematik dichotomisiert'.
VALUE LABELS Selbstkonzept_d 0 "niedrig" 1 "hoch".
EXECUTE.
*
*******************************************************************************************
*
* Beispielcodes für Tabelle 16-3; Seite 188: Fünf bivariate Tabellen im Vergleich
*
********************************************************************************************
*
* Diese Befehlsfolge reproduziert das Ergebnis für den Zusammenhang zwischen den Variablen 
* Kompetenz_d (a. V.) und Bildung_d (u. V.) der ersten Spalte der Tabelle 16-3 auf Seite 194
* und entspricht dem Pfad auf Seite 184 bzw. dem Screenshot in der Abbildung 16-2.

* Markieren Sie für jede Befehlsfolge mit der Maus die Zeilen und aktivieren Sie danach die Berechnung durch einen Klick 
* auf das Symbol Syntax-Start (Ausführen oder grünes Dreieck im Syntax-Editor).

CROSSTABS
  /TABLES=Kompetenz_d BY Bildung_d
  /FORMAT=AVALUE TABLES
  /STATISTICS=CHISQ CC PHI LAMBDA UC ETA CORR GAMMA D BTAU CTAU RISK CMH(1)
  /CELLS=COLUMN
  /COUNT ROUND CELL.
*
***************************************************************
* Diese Befehlsfolge reproduziert das Ergebnis für den Zusammenhang zwischen den Variablen 
* Kompetenz_d (a. V.) und Geschlecht (u. V.) auf Seite 188.

 CROSSTABS
  /TABLES=Kompetenz_d BY Geschlecht
  /FORMAT=AVALUE TABLES
  /STATISTICS=CHISQ CC PHI LAMBDA UC ETA CORR GAMMA D BTAU CTAU RISK CMH(1)
  /CELLS=COLUMN 
  /COUNT ROUND CELL.
*
***************************************************************
* Diese Befehlsfolge reproduziert das Ergebnis für den Zusammenhang zwischen den Variablen 
* Kompetenz_d (a. V.) und Migration (u. V.) auf Seite 188.

CROSSTABS
  /TABLES=Kompetenz_d BY Migration
  /FORMAT=AVALUE TABLES
  /STATISTICS=CHISQ CC PHI LAMBDA UC ETA CORR GAMMA D BTAU CTAU RISK CMH(1)
  /CELLS=COLUMN 
  /COUNT ROUND CELL.
*
*****************************************************************
* Diese Befehlsfolge reproduziert das Ergebnis für den Zusammenhang zwischen den Variablen 
* Kompetenz_d (a. V.) und Freude_d (u. V.) auf Seite 188.

CROSSTABS
  /TABLES=Kompetenz_d BY Freude_d
  /FORMAT=AVALUE TABLES
  /STATISTICS=CHISQ CC PHI LAMBDA UC CORR GAMMA D BTAU CTAU RISK CMH(1)
  /CELLS=COLUMN 
  /COUNT ROUND CELL.
*
********************************************************************
* Diese Befehlsfolge reproduziert das Ergebnis für den Zusammenhang zwischen den Variablen 
* Kompetenz_d (a. V.) und dem Selbstkonzept_d (u. V.) auf Seite 188.

CROSSTABS
  /TABLES=Kompetenz_d BY Selbstkonzept_d
  /FORMAT=AVALUE TABLES
  /STATISTICS=CHISQ CC PHI LAMBDA UC CORR GAMMA D BTAU CTAU RISK CMH(1)
  /CELLS=COLUMN 
  /COUNT ROUND CELL.
*
**********************************************************************
*
* 16.4 Mehrdimensionale Tabellen 
*
************************************************************************
*
* Beispielcodes für Tabelle 16-4; Seite 190: Zusammenhang zwischen den Variablen Kompetenz und Bildung  
* mit Migration als Kontrollvariable in Prozenten Seite 190 
*
* Diese Befehlsfolge entspricht dem Pfad auf Seite 189 bzw. den Screenshots in den Abbildung 16-3 und 16-4.
*
* Markieren Sie mit der Maus die Zeile CROSSTABS bis  /COUNT ROUND CELL. und aktivieren Sie danach
* die Befehlsfolge durch einen Klick auf das grüne Dreieck zur Berechnung.

CROSSTABS
  /TABLES=Kompetenz_d BY Bildung_d BY Migration
  /FORMAT=AVALUE TABLES
  /STATISTICS=CHISQ GAMMA D RISK CMH(1)
  /CELLS=COLUMN 
  /COUNT ROUND CELL.
*
************************************************************************
* Ergebnis des SPSS-Output nach Excel exportieren
* Speicherort auf dem Computer muss gewählt werden: /XLS  DOCUMENTFILE=

OUTPUT EXPORT
  /CONTENTS  EXPORT=ALL  LAYERS=PRINTSETTING  MODELVIEWS=PRINTSETTING
  /XLS  DOCUMENTFILE=''Wahl des Speicherortes auf dem Computer'
        OPERATION=CREATEFILE
     LOCATION=LASTCOLUMN  NOTESCAPTIONS=YES.

